Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[caves.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[tutorial_grenades.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		StartBPMultiplier 	= 1.0,
		BPGainMultiplier 	= 1.0,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 10.0,
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
			[[MU_GRENADES]],
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	}
}

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		GameWorld:SetUIVisibility("ResourceGroup", false)
		GameWorld:SetUIVisibility("commandMenu", false)
		GameWorld:SetUIVisibility("constructionMenu", false)
		GameWorld:SetUIVisibility("MutationList", false)
		GameWorld:SetUIVisibility("Objectives", false)
		GameWorld:SetUIVisibility("researchMenu", false)
		GameWorld:SetUIVisibility("trainingMenu", false)
		GameWorld:SetUIVisibility("armouryMenu", false)
		
		MarineSelectGoal:Enable()
		
		self:Disable()
	end)
LevelInit:Enable()
	
------------------------------------------------------------------------------- Select Marines
MarineSelectGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:CreateTrainingArrow("firstPoint")
		GameWorld:ShowText("Would you look at that?\n\nI wonder if the general would notice if we kept a couple boxes?  Maybe a couple dozen?", "Sarge")
	end,
	
	{[[NT_ENTITY_SELECTION]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:SetUIVisibility("ResourceGroup", true)
		GameWorld:SetUIVisibility("commandMenu", true)
		
		GrenadeOrderGoal:Enable()
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("firstPoint")
	end)

------------------------------------------------------------------------------- Killed tower with normal weapons - respawn it (script)
BadKillTowerScript = LevelUtils.MakeGoal(
	function (self)

		local grenadeArea = GameWorld:GetEntityById("grenadeArea")
		self.event_pos = grenadeArea:GetPos()
		self.event_radius = grenadeArea:GetRadius()	
	
	end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if not vect2f.IsDistLess(p_pos, self.event_pos, self.event_radius) then
			return
		end

		local ent = GameWorld:GetEntityById(p_entId)
		if not ent:GetBuilding() then
			return
		end
	
		local deltaV = vect2f.MakePolar(math.sqrt(GetRandomRange(0, self.event_radius*self.event_radius)),
										GetRandomRange(0, math.pi*2))
										
										
		GameWorld:CreateEntity("DefTower", "", self.event_pos + deltaV, 0)
		GameWorld:CreateEntity("Barrier", "", self.event_pos + deltaV, 0)
		
	end,
	
	function (self)
	end)


------------------------------------------------------------------------------- Grenade strike happened
GrenadeOrderGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("No need to be stingy with the rockets, squad.  Let's go blow some stuff up!", "Sarge")
		GameWorld:SetEntityVisible("grenadeArea", true)
		GameWorld:CreateTrainingArrow("grenadeArea")
		
		GameWorld:SetUIHighlightArrow("commandMenu", "Command:GrenadeAttack", true)
		
		local grenadeArea = GameWorld:GetEntityById("grenadeArea")
		self.event_pos = grenadeArea:GetPos()
		self.event_radius = grenadeArea:GetRadius()
		self.grenade_count = 0
		
		GameWorld:FreezeAmmoRecharge(true)
		
		BadKillTowerScript:Enable()
	end,
	
	{[[NT_GRENADE_TOSSED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if not vect2f.IsDistLess(p_pos, self.event_pos, self.event_radius) then
			return
		end
	
		self.grenade_count = self.grenade_count + 1
		
		if self.grenade_count < 3 then
		    return
		end
		
		CaptureCrateGoal:Enable()
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:KillEntity("grenadeArea")
		
		BadKillTowerScript:Disable()
		
		GameWorld:SetUIHighlightArrow("commandMenu", "Command:GrenadeAttack", false)
	end)

------------------------------------------------------------------------------- Refill Ammo From Crate
CaptureCrateGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Heh, guess we'll have to borrow some rockets from the army.\n\nPlenty more in that crate over there.", "Sarge")
		GameWorld:SetUIHighlightArrow("ResourceGroup", "ammo_counter", true)
		GameWorld:CreateTrainingArrow("exampleCrate")
	end,
	
	{[[NT_POWERUP_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:FreezeAmmoRecharge(false)
	
		AmmoObjective:Enable()
		CaptureAllObjective:Enable()
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:SetUIHighlightArrow("ResourceGroup", "ammo_counter", false)
		GameWorld:RemoveTrainingArrow("exampleCrate")
		--GameWorld:ClearText()
	end)
	
------------------------------------------------------------------------------- Tracked objective for collecting ammo
AmmoObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:CreateTracker("ammoRecharge", "ST_AMMO_CHARGED", 30)
		GameWorld:AddObjective("ammoObj", "Reload using the crates", "", "ammoRecharge")
	end,
	
	{[[NT_TRACKER_THRESHOLD]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if p_entId ~= "ammoRecharge" then
			return
		end
		
		GameWorld:ChangeObjectiveStatus("ammoObj", [[complete]])
		--GameWorld:MakeAnnouncement("Objective\nComplete")
		GameWorld:ChangeStat("ST_OBJECTIVE_REWARD_COUNT", 1)
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
		
		local textHdl = GameWorld:ShowText("Oh man, this is going to be fun.\n\nNearly as good as that time that I 'borrowed' a tank.", "Sarge")
		ScriptMgr:DoDelayedCall(15000, 	function ()
											textHdl:ClearText()
											CaptureOneDialogue:Enable()
										end)	
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)	

------------------------------------------------------------------------------- Triggered dialogue	
CaptureOneDialogue = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		self:Disable()
		
		local textHdl = GameWorld:ShowText("I wonder what the boss man has in store for us\n\nHeard that the army's preparin for a big push.  Good plan if it works.  Not so good if we get bogged down pullin grubs out of our boots.", "Sarge")
		ScriptMgr:DoDelayedCall(15000, 	function ()
											textHdl:ClearText()
										end)		
	end)
	

	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()
